<?php
$posts_per_page = $settings['query_posts_per_page'];
$post_categories = $settings['query_post_categories'];
$post_tags = $settings['query_post_tags'];
$show_thumbnail = $settings['layout_show_thumbnail'];
$show_category = $settings['layout_show_category'];
$number_of_categories = $settings['layout_number_of_categories'];
$show_date = $settings['layout_show_date'];
$orderby = $settings['query_orderby'];
$order = $settings['query_order'];
$post_title_crop = isset($settings['layout_post_title_crop']) ? $settings['layout_post_title_crop']['size'] : '35';
$show_author = $settings['layout_show_author'];
$show_view_count = $settings['layout_show_view_count'];
$show_read_time = $settings['layout_show_read_time'];
$show_readmore = $settings['layout_show_read_more_link'];
$readmore_text = $settings['layout_read_more_text'];
$read_more_icon = $settings['layout_read_more_icon'];
$show_content = $settings['layout_show_content'];
$post_content_crop = isset($settings['layout_post_content_crop']) ? $settings['layout_post_content_crop']['size'] : '20';
$post_format = $settings['query_post_format'];
$category_position = $settings['layout_category_position'];
$layout_thumbnail_img_size = $settings['layout_thumbnail_img_size_size'];
$thumbnail_image_aspect_ratio = $settings['layout_thumbnail_image_aspect_ratio']['size'];
$video_icon = 'no';
$category_style = $settings['layout_category_style'];

$desktop_column_number = ( isset($settings['layout_column_number']) ) ? $settings['layout_column_number']: 3;
$tablet_column_number = ( isset($settings['layout_column_number_tablet']) ) ? $settings['layout_column_number_tablet']: 2; 
$mobile_column_number = ( isset($settings['layout_column_number_mobile']) ) ? $settings['layout_column_number_mobile']: 1;

$column_desktop = round(12 / (int)$desktop_column_number);
$column_tablet = round(12 / (int)$tablet_column_number);
$column_mobile = round(12 / (int)$mobile_column_number);

$show_loadmore = $settings['show_loadmore'];

$show_review_rating = $settings['layout_show_review_rating'];
$show_review_rating_style2 = 'no';
$show_review_rating_style1 = 'no';
if($show_review_rating == 'yes') {
    $review_style = $settings['layout_review_style'];
    if($review_style == 'style2') {
        $show_review_rating_style2 = 'yes';
    } else {
        $show_review_rating_style1 = 'yes';
    }
}


$args = array(
    'posts_per_page' => $posts_per_page,
    'orderby' => $orderby,
    'order' => $order
);

if (!empty($post_categories)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'terms' => $post_categories,
            'field' => 'id'
        ),
    );
}

if (!empty($post_tags)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_tag',
            'terms' => $post_tags,
            'field' => 'id'
        ),
    );
}

if (in_array('video', $post_format) && !in_array('standard', $post_format)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'post_format',
            'field' => 'slug',
            'terms' => array('post-format-video'),
            'operator' => 'IN'
        )
    );
}

if ($settings['query_enable_offset'] == 'yes') {
    $args['offset'] = $settings['query_offset_item_num'];
}

$style_class = $settings['layout_layout_style'];

$query = new \WP_Query($args);

        $ajax_json_data = [
        'query_order'                   => $order,
        'query_posts_per_page'          => $posts_per_page,
        'query_post_categories'         => $post_categories,
        'layout_number_of_categories'   => $number_of_categories,
        'query_post_tags'               => $post_tags,
        'query_orderby'                 => $orderby,
        'total_post'                    => $query->found_posts,
        'layout_layout_style'           => $style_class,
        'layout_show_category'          => $show_category,
        'layout_show_author'            => $show_author,
        'layout_show_view_count'        => $show_view_count,
        'layout_show_date'              => $show_date,
        'layout_show_content'           => $show_content,
        'layout_post_content_crop'      => $post_content_crop,
        'layout_post_title_crop'        => $post_title_crop,
        'layout_show_thumbnail'         => $show_thumbnail,
        'layout_category_position'      => $category_position,
        'layout_show_read_time'         => $show_read_time,
        'layout_show_read_more_link'    => $show_readmore,
        'layout_readmore_text'         => $readmore_text,
        'layout_read_more_icon'         => $read_more_icon,
        'layout_column_number'          => $column_desktop,
        'layout_column_number_tablet'   => $column_tablet,
        'layout_column_number_mobile'   => $column_mobile,
        'layout_thumbnail_img_size_size'  => $layout_thumbnail_img_size,
        'layout_thumbnail_image_aspect_ratio_size'  => $thumbnail_image_aspect_ratio,
        'show_review_rating_style1'         => $show_review_rating_style1,
        'show_review_rating_style2'         => $show_review_rating_style2,
        'layout_category_style'             => $category_style,
        ]; 

        $ajax_json_data = json_encode($ajax_json_data);
        $loadmore_class = 'post-grid-loadmore';

?>


<div class="qoxag-wrapper qoxag-post-grid">
    <div class="row grid-loadmore-content">
        <?php if ($query->have_posts()) { ?>
        <?php
        while ($query->have_posts()) : $query->the_post();

            ?>
            <div class="grid-item col-lg-<?php echo esc_attr($column_desktop); ?> col-md-<?php echo esc_attr($column_tablet); ?> col-sm-<?php echo esc_attr($column_mobile); ?>">
                <?php
                $postid = get_the_ID();
                include QOXAG_CORE . "/elementor/content-parts/content-1.php";
                ?>
            </div>
            <?php
        endwhile;
        ?>
        <?php } ?>
    </div>

    <?php if ($show_loadmore == 'yes') { ?>
        <?php if ($query->max_num_pages > 1) { ?>
            <div class="load-more-btn text-center">
                <button class="post-grid-loadmore" data-json_grid_meta="<?php echo esc_attr($ajax_json_data); ?>">
                    <?php echo esc_html__('Load More', 'qoxag'); ?>
                </button>
            </div>
        <?php } ?>
    <?php } ?>

    <!-- content will be here -->
</div>
